﻿// load the file
function loadFile( filename:String, dest_array:Array, callTarget )
{
	trace("loadFile()");
	trace("dest_array: "+dest_array);
	// create a movieClip to revieve new data  &  store load settings
	// // I use a movieClip because it persists beyond scope
	if (newData_mc == undefined)
	{
		createEmptyMovieClip("newData_mc", this.getNextHighestDepth() );
	}
	// Store parameters in the movieclip,  to preserve them across function calls
	newData_mc.dest_array = dest_array;		// store data destination
	newData_mc.callTarget = callTarget;			// store callback target
	//newData_mc.dest_array = new Array();		// clear old data
	newData_mc.newData = undefined;		// clear old data
	trace("erase:  newData_mc.newData = "+newData_mc.newData);
	trace("loading: "+filename+"   into: "+newData_mc);
	loadVariables(filename, newData_mc);
	newData_mc.callTarget.onLoadStart();		// Callback:  Loading has begun
	
	repeatCheckLoad = setInterval(checkLoad, 100);		// Periodically check if loading has finished
}


	
function checkLoad()
{
	trace("checkLoad()");
	trace("newData_mc.newData: "+newData_mc.newData);
	trace("location: "+this);
	if (newData_mc.newData != undefined)
	{
		trace("done loading");
		trace("raw data:   "+newData_mc.newData);
		newData_mc.callTarget.onLoadComplete();		// Callback:	Loading was successful
		clearInterval(repeatCheckLoad);
		parseLoadedData();		// Read data into the specified array
	}else{
		trace("still loading");
		newData_mc.callTarget.onLoadProgress();			// Callback:	Loading has not completed yet  (for whatever reason)
	}
}
	
	
	
	// SUPPORT FUNCTIONS
function parseLoadedData()
{
	//
	readCharacter = "";
	newName = "";
	for ( var i = 0; i < newData_mc.newData.length; i++)
	{
		readCharacter = newData_mc.newData.charAt(i);
		trace("readCharacter: "+readCharacter);
		trace("ascii code: "+newData_mc.newData.charCodeAt(i) );
		if (newData_mc.newData.charCodeAt(i) == 10 )
		{
			// It's the end of this line, so add the name
			if (newName != "")
			{
				newData_mc.dest_array.push( newName );
			}
			newName = "";
		}
		else if (newData_mc.newData.charCodeAt(i) == 13 )
		{
			// extra carriage return code, so ignore it
		}
		else
		{
			// assume this character is part of the current name, so add it
			newName += readCharacter;
		}// END if
	}// END for
	// if the file ends on something other than a carriage return, assume there's one more name to add

	// back up to look at the last character
	i--;
	if (newData_mc.newData.charCodeAt(i) != 13  &&  newData_mc.newData.charCodeAt(i) != 10 )
	{
		trace("index: "+i);
		trace("newName = "+newName);
		trace("ascii code: "+newData_mc.newData.charCodeAt(i));
		trace("it's not a carriage return, so there must be one more name, add it to the list.");
		newData_mc.dest_array.push( newName );
	}
	
	// Output
	trace("newData_mc.dest_array: "+newData_mc.dest_array);
	var output = newData_mc.dest_array;
	newData_mc.callTarget.onLoadInit( output );
	
	// CLEAN-UP
	delete newName;
	delete readCharacter;
	// // newData_mc...  just... won't...DIE!!  (removeMovieClip() doesn't work)   So just delete it's contents. 
	delete	newData_mc.dest_array;
	delete	newData_mc.callTarget;
	delete	newData_mc.newData;
	newData_mc.removeMovieClip();
}